/**
 * zen_manager.js
 * Zen Coding for gPad
 */

#include "zen_settings.js"
#include "zen_resources.js"
#include "zen_parser.js"
#include "zen_coding.js"
#include "zen_actions.js"
#include "html_matcher.js"
#include "base64.js"
#include "parsers\parsexml.js"
#include "parsers\sex.js"
#include "parsers\parserutils.js"
#include "parsers\actions.js"
#include "parsers\traverse-actions.js"
#include "filters\comment.js"
#include "filters\css.js"
#include "filters\escape.js"
#include "filters\format-css.js"
#include "filters\format.js"
#include "filters\haml.js"
#include "filters\html.js"
#include "filters\single-line.js"
#include "filters\trim.js"
#include "filters\xsl.js"
#include "zen_editor.js"

function zc_manager( action_name ) {
	zen_editor.setContext( null );
	if (action_name == 'wrap_with_abbreviation') {
		var abbr = prompt('Enter Abbreviation', "" );
		if (abbr)
			zen_coding.runAction(action_name, zen_editor, abbr);
		
	} else {
		return zen_coding.runAction(action_name, zen_editor);
	}
}
