/**
 * emmet_menu.js
 * Emmet for gPad
 */

#include ".editor\manager.js"

menu = CreatePopupMenu();
menu.Add( '&Expand Abbreviation'		, 101 );
menu.Add( '&Wrap with Abbreviation'		, 102 );
menu.Add( '&Balance Tag'				, 103 );
menu.Add( 'B&alance Tag Inward'			, 104 );
menu.Add( '&Merge Lines'				, 105 );
menu.Add( '&Next Edit Point'			, 106 );
menu.Add( '&Previous Edit Point'		, 107 );
menu.Add( 'Remove Ta&g'					, 108 );
menu.Add( '&Split/Join Tag'				, 109 );
menu.Add( '&Toggle Comment'				, 110 );
menu.Add( '------------------------'	, 0		, eMenuSeparator );

// v0.7
menu.Add( 'E&valuate Math Expression'	, 201 );
menu.Add( 'Increment number by &1'		, 202 );
menu.Add( '&Decrement number by 1'		, 203 );
menu.Add( 'Increment number by 0&.1'	, 204 );
menu.Add( 'De&crement number by 0.1'	, 205 );
menu.Add( 'Increment number by 1&0'		, 206 );
menu.Add( 'Dec&rement number by 10'		, 207 );
menu.Add( '------------------------'	, 0		, eMenuSeparator );

menu.Add( 'Select Next &Item'			, 301 );
menu.Add( 'Select Previ&ous Item'		, 302 );
menu.Add( 'Re&flect CSS Value'			, 303 );

var nRet = menu.Track();

switch( nRet )
{
case 101: emmet_manager( 'expand_abbreviation' ); 			break;
case 102: emmet_manager( 'wrap_with_abbreviation' ); 		break;
case 103: emmet_manager( 'match_pair_outward' );			break;
case 104: emmet_manager( 'match_pair_inward' );				break;
case 105: emmet_manager( 'merge_lines' );					break;
case 106: emmet_manager( 'next_edit_point' );				break;
case 107: emmet_manager( 'prev_edit_point' );				break;
case 108: emmet_manager( 'remove_tag' );					break;
case 109: emmet_manager( 'split_join_tag' );				break;
case 110: emmet_manager( 'toggle_comment' );				break;

case 201: emmet_manager( 'evaluate_math_expression' );		break;
case 202: emmet_manager( 'increment_number_by_1' );			break;
case 203: emmet_manager( 'decrement_number_by_1' );			break;
case 204: emmet_manager( 'increment_number_by_01' );		break;
case 205: emmet_manager( 'decrement_number_by_01' );		break;
case 206: emmet_manager( 'increment_number_by_10' );		break;
case 207: emmet_manager( 'decrement_number_by_10' );		break;

case 301: emmet_manager( 'select_next_item' );				break;
case 302: emmet_manager( 'select_previous_item' );			break;
case 303: emmet_manager( 'reflect_css_value' );				break;
}
