/**
 * manager.js
 * Emmet for gPad
 */

#include "..\.javascript\underscore.js"

#include "..\.javascript\core.js"

#include "..\.javascript\parsers\abbreviationParser.js"
#include "..\.javascript\parsers\processors\resource-matcher.js"
#include "..\.javascript\parsers\processors\pasted-content.js"
#include "..\.javascript\parsers\processors\tag-name.js"
#include "..\.javascript\parsers\cssParser.js"
#include "..\.javascript\parsers\xmlParser.js"

#include "..\.javascript\string-score.js"
#include "..\.javascript\utils.js"
#include "..\.javascript\range.js"
#include "..\.javascript\handlerList.js"
#include "..\.javascript\tokenIterator.js"
#include "..\.javascript\stringStream.js"
#include "..\.javascript\resources.js"
#include "..\.javascript\actions.js"
#include "..\.javascript\profile.js"
#include "..\.javascript\editorUtils.js"
#include "..\.javascript\actionUtils.js"
#include "..\.javascript\abbreviationUtils.js"
#include "..\.javascript\base64.js"
#include "..\.javascript\htmlMatcher.js"
#include "..\.javascript\tabStops.js"
#include "..\.javascript\preferences.js"
#include "..\.javascript\elements.js"

#include "..\.javascript\filters.js"
#include "..\.javascript\filters\bem.js"
#include "..\.javascript\filters\comment.js"
#include "..\.javascript\filters\escape.js"
#include "..\.javascript\filters\format.js"
#include "..\.javascript\filters\haml.js"
#include "..\.javascript\filters\html.js"
#include "..\.javascript\filters\single-line.js"
#include "..\.javascript\filters\trim.js"
#include "..\.javascript\filters\xsl.js"

#include "..\.javascript\parsers\editTree\editTree.js"
#include "..\.javascript\parsers\editTree\cssEditTree.js"
#include "..\.javascript\parsers\editTree\xmlEditTree.js"

#include "..\.javascript\actions\base64.js"
#include "..\.javascript\actions\editPoints.js"
#include "..\.javascript\actions\evaluateMath.js"
#include "..\.javascript\actions\expandAbbreviation.js"
#include "..\.javascript\actions\increment_decrement.js"
#include "..\.javascript\actions\lineBreaks.js"
#include "..\.javascript\actions\matchPair.js"
#include "..\.javascript\actions\mergeLines.js"
#include "..\.javascript\actions\reflectCSSValue.js"
#include "..\.javascript\actions\removeTag.js"
#include "..\.javascript\actions\selectItem.js"
#include "..\.javascript\actions\selectLine.js"
#include "..\.javascript\actions\splitJoinTag.js"
#include "..\.javascript\actions\toggleComment.js"
#include "..\.javascript\actions\wrapWithAbbreviation.js"
#include "..\.javascript\actions\updateImageSize.js"

#include "..\.javascript\resolvers\css.js"
#include "..\.javascript\resolvers\generator.js"
#include "..\.javascript\resolvers\cssGradient.js"
#include "..\.javascript\resolvers\tagName.js"

#include "..\.javascript\generators\lorem-ipsum.js"

#include "editor.js"
#include "snippets.json.begin"
#include "snippets.json"
#include "snippets.json.end"

function emmet_manager( action_name ) {
	editorProxy.setContext( null );
	if (action_name == 'wrap_with_abbreviation') {
		var abbr = prompt('Enter Abbreviation', "" );
		if (abbr)
		 	emmet.require('actions').run( action_name, editorProxy, abbr );
	} else {
	 	emmet.require('actions').run( action_name, editorProxy);
	}
}
